/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile.dispenser;

import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vectorwing.farmersdelight.blocks.CuttingBoardBlock;
import vectorwing.farmersdelight.tile.CuttingBoardTileEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardDispenseBehavior
extends OptionalDispenseBehavior {
    private static final DispenserLookup BEHAVIOUR_LOOKUP = new DispenserLookup();
    private static final HashMap<Item, IDispenseItemBehavior> DISPENSE_ITEM_BEHAVIOR_HASH_MAP = new HashMap();

    public static void registerBehaviour(Item item, CuttingBoardDispenseBehavior behavior) {
        DISPENSE_ITEM_BEHAVIOR_HASH_MAP.put(item, BEHAVIOUR_LOOKUP.func_149940_a(new ItemStack((IItemProvider)item)));
        DispenserBlock.func_199774_a((IItemProvider)item, (IDispenseItemBehavior)behavior);
    }

    public final ItemStack dispense(IBlockSource source, ItemStack stack) {
        if (this.tryDispenseStackOnCuttingBoard(source, stack)) {
            this.func_82485_a(source);
            this.func_82489_a(source, (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
            return stack;
        }
        return DISPENSE_ITEM_BEHAVIOR_HASH_MAP.get(stack.func_77973_b()).dispense(source, stack);
    }

    public boolean tryDispenseStackOnCuttingBoard(IBlockSource source, ItemStack stack) {
        this.func_239796_a_(false);
        ServerWorld world = source.func_197524_h();
        BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a));
        BlockState blockstate = world.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        TileEntity te = world.func_175625_s(blockpos);
        if (block instanceof CuttingBoardBlock && te instanceof CuttingBoardTileEntity) {
            CuttingBoardTileEntity tileEntity = (CuttingBoardTileEntity)te;
            ItemStack boardItem = tileEntity.getStoredItem().func_77946_l();
            if (!boardItem.func_190926_b() && tileEntity.processItemUsingTool(stack, null)) {
                CuttingBoardBlock.spawnCuttingParticles((World)world, blockpos, boardItem, 5);
                this.func_239796_a_(true);
            }
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class DispenserLookup
    extends DispenserBlock {
        protected DispenserLookup() {
            super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150367_z));
        }

        public IDispenseItemBehavior func_149940_a(ItemStack itemStack) {
            return super.func_149940_a(itemStack);
        }
    }
}

